# Introduction

This is the implementation of our paper *GPFL: Simultaneously Learning Generic and Personalized Feature Information for Personalized Federated Learning*


# Dataset

Due to the file size limitation of the supplementary material, we only upload the mnist dataset with the practical *label skew* setting ($\beta=0.1$). 


# System

- `main.py`: configurations of **GPFL**. 
- `run_me.sh`: start **GPFL**. 
- `env_linux.yaml`: python environment to run **GPFL** on Linux. 
- `./flcore`: 
    - `./clients/clientgp.py`: the code on the client. 
    - `./servers/servergp.py`: the code on the server. 
    - `./trainmodel/models.py`: the code for backbones. 
- `./utils`:
    - `data_utils.py`: the code to read the dataset. 

# Simulation

## Environments
With the installed [conda](https://repo.anaconda.com/miniconda/Miniconda3-latest-Linux-x86_64.sh), we can run this platform in a conda virtual environment called *fl_torch*. 
```
conda env create -f env_linux.yaml # for Linux
```


## Training and Evaluation

All codes corresponding to **GPFL** are stored in `./system`. Just run the following commands.

```
cd ./system
sh run_me.sh
```